CREATE OR REPLACE PACKAGE SIM2_EXPORT_PKG IS

   /* import utils by SNG Feb 2000 */  



  PROCEDURE UPDATE_STATIONS_EISN_TABLE (p_tsmstatn_is_nbr IN NUMBER, p_tsmalp_is_nbr IN NUMBER,
                                      p_tsmwell_is_nbr IN NUMBER, p_tsmigua_is_nbr IN NUMBER,
                                      p_tsmintvl_is_nbr IN NUMBER, p_tsmcsng_is_nbr IN NUMBER,
                                      p_org_id IN VARCHAR2);
                                      
  FUNCTION check_single_user RETURN NUMBER;               
                          
  FUNCTION get_eisn_number(p_table_name IN VARCHAR2, p_org_id IN VARCHAR2) RETURN NUMBER;
  
  PROCEDURE UPDATE_EISN_TABLE (p_tsrfdset_is_nbr IN NUMBER, p_tsrtrip_is_nbr IN NUMBER,
                               p_tsrrsult_is_nbr IN NUMBER, p_tsmgntxt_is_nbr IN NUMBER, 
                               p_tsrfdact_is_nbr IN NUMBER, p_tsrstvst_is_nbr IN NUMBER, 
                               p_tsrfqs_is_nbr IN NUMBER, p_org_id IN VARCHAR2);

  PROCEDURE UPDATE_TSMEISN (p_org_id IN varchar2, p_table_name IN VARCHAR2, p_max_is_nbr IN NUMBER);

  FUNCTION get_tsmorgan_is_number (p_org_id IN VARCHAR2) RETURN NUMBER;
  
  PROCEDURE CLEAR_STORET_EXPORT (p_export_log_seq IN NUMBER);

  PROCEDURE WRITE_ERROR (p_export_seq IN NUMBER, p_desc IN VARCHAR2);
  
  FUNCTION GET_EXPORT_LOG_SEQ RETURN NUMBER;
  
  PROCEDURE CLEAR_STATION_EXPORT (p_export_log_seq IN NUMBER);
  
  FUNCTION CLEAR_EXPORT (p_export_log_seq IN NUMBER) RETURN NUMBER;
  
END;
/
CREATE OR REPLACE PACKAGE BODY SIM2_EXPORT_PKG as

/*
Change Log
3/12/02 - SF 
Fixed bug where the value being passed to Update_EISN for TSRFQS was the wrong number,
so the EISN Table was not being updated for trip qc records.
Change Log

6/16/2000 - 
1. added GET_NEXT_STAVST_ID to get the next station visit # by selecting the count
   of the ones already existing instead of incrementing a counter

*/

/******************************************************************************************************/
/******************************************************************************************************/
PROCEDURE UPDATE_STATIONS_EISN_TABLE (p_tsmstatn_is_nbr IN NUMBER, p_tsmalp_is_nbr IN NUMBER,
                                      p_tsmwell_is_nbr IN NUMBER, p_tsmigua_is_nbr IN NUMBER,
                                      p_tsmintvl_is_nbr IN NUMBER, p_tsmcsng_is_nbr IN NUMBER,
                                      p_org_id IN VARCHAR2) IS

  v_is_number NUMBER(8);
     
BEGIN

      /* TSMSTATN - STATIONS */
      v_is_number := p_tsmstatn_is_nbr;
      IF v_is_number IS NOT NULL THEN
        sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSMSTATN', v_is_number);
      END IF;
  
      /*TSMALP */
      v_is_number := p_tsmalp_is_nbr;  
      IF v_is_number IS NOT NULL THEN
         sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSMALP', v_is_number);
      END IF;

      /*TSMWELL */
      v_is_number := p_tsmwell_is_nbr;  
      IF v_is_number IS NOT NULL THEN   
         sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSMWELL', v_is_number);
      END IF;
       /*TSMIGUA */
      v_is_number := p_tsmigua_is_nbr;  
      IF v_is_number IS NOT NULL THEN   
         sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSMIGUA', v_is_number);
      END IF;

      /* TSMINTVL */
      v_is_number := p_tsmintvl_is_nbr;   
      IF v_is_number IS NOT NULL THEN   
        sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSMINTVL', v_is_number);
      END IF;

     /* TSMCSNG */
      v_is_number := p_tsmcsng_is_nbr;   
      IF v_is_number IS NOT NULL THEN   
        sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSMCSNG', v_is_number);
      END IF;




      COMMIT;

END UPDATE_STATIONS_EISN_TABLE;

/******************************************************************************************************/
/******************************************************************************************************/
/* Add a configuration item ITEM = "SINGLE_USER_ENVIRONMENT", VALUE = "YES" or
"NO", DESC = "If only one user will be accessing the STORET database at any
given time set this to "YES" to increase the speed of migration."

 Now: If the value is YES we'll continue to do EISN updates the way we're
doing them. If the value is NO then have all the EISN updates in the export
packages happen after each migrated record. You should probably lock the
EISN table while the record in being migrated.

****************************************************************************************************/
FUNCTION check_single_user RETURN NUMBER IS

   v_single_user VARCHAR2(30);

  CURSOR c_single_user IS
    SELECT SC_VALUE FROM SIM_CONFIG
      WHERE SC_ITEM = 'SINGLE_USER_ENVIRONMENT';


BEGIN

  OPEN c_single_user;
  FETCH c_single_user INTO v_single_user;
  CLOSE c_single_user;

  IF v_single_user = 'YES' THEN
   RETURN 1;
  ELSE 
   RETURN 0;
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    RETURN 0;
  
END;
/******************************************************************************************************/

FUNCTION get_eisn_number(p_table_name IN VARCHAR2, p_org_id IN VARCHAR2) RETURN NUMBER IS

  v_is_number           NUMBER(8);

  CURSOR c_get_number(p_table_name IN VARCHAR2, p_org_id IN VARCHAR2) IS
    SELECT IS_NUMBER FROM TSMEISN WHERE TSMEISN_NAME = RPAD(p_table_name,8)
      AND TSMEISN_ORG_ID = RPAD(p_org_id,8)
      FOR UPDATE; -- Locks table while being used
     
BEGIN

  OPEN c_get_number(p_table_name, p_org_id);
  FETCH c_get_number INTO v_is_number;
    IF c_get_number%NOTFOUND THEN
      INSERT INTO TSMEISN(TSMEISN_NAME,TSMEISN_ORG_ID,IS_NUMBER) 
      VALUES (p_table_name,p_org_id,1);
      v_is_number := 1;
    END IF;
  CLOSE c_get_number;
  
  RETURN v_is_number + 1;

END get_eisn_number;

/******************************************************************************************************/
PROCEDURE UPDATE_EISN_TABLE (p_tsrfdset_is_nbr IN NUMBER, p_tsrtrip_is_nbr IN NUMBER,
                             p_tsrrsult_is_nbr IN NUMBER, p_tsmgntxt_is_nbr IN NUMBER, 
                             p_tsrfdact_is_nbr IN NUMBER, p_tsrstvst_is_nbr IN NUMBER, 
                             p_tsrfqs_is_nbr IN NUMBER, p_org_id IN VARCHAR2) IS

  v_is_number NUMBER(8);
     
    
BEGIN

   /* TSRFDSET - field sets */
   v_is_number := p_tsrfdset_is_nbr;
   IF v_is_number IS NOT NULL THEN
     sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSRFDSET', v_is_number);
   END IF;
  
   /* TSRTRIP */
   v_is_number := p_tsrtrip_is_nbr;
   IF v_is_number IS NOT NULL THEN
     sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSRTRIP ', v_is_number);
   END IF;

   /*TSRRSULT */
   v_is_number := p_tsrrsult_is_nbr;  
   IF v_is_number IS NOT NULL THEN
     sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSRRSULT', v_is_number);
   END IF;
   
   /* TSMGNTXT */
   v_is_number := p_tsmgntxt_is_nbr;  
   IF v_is_number IS NOT NULL THEN   
     sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSMGNTXT', v_is_number);
   END IF;

   /* tsrfdact */
   v_is_number := p_tsrfdact_is_nbr;   
   IF v_is_number IS NOT NULL THEN   
     sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSRFDACT', v_is_number);
   END IF;
        
   /* tsrstvst */
   v_is_number := p_tsrstvst_is_nbr;   
   IF v_is_number IS NOT NULL THEN   
     sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSRSTVST', v_is_number);
   END IF;
   
   /* tsrfqs */
   v_is_number := p_tsrfqs_is_nbr;   
   IF v_is_number IS NOT NULL THEN   
     sim2_export_pkg.UPDATE_TSMEISN (p_org_id, 'TSRFQS', v_is_number);
   END IF;

   COMMIT;

END UPDATE_EISN_TABLE;

/******************************************************************************************************/
PROCEDURE UPDATE_TSMEISN (p_org_id IN varchar2, p_table_name IN VARCHAR2, p_max_is_nbr IN NUMBER) IS

BEGIN

   UPDATE tsmeisn
      SET is_number = p_max_is_nbr WHERE tsmeisn_name = RPAD(p_table_name,8)
      AND TSMEISN_ORG_ID = RPAD(p_org_id,8);

   COMMIT;

END UPDATE_TSMEISN;

/******************************************************************************************************/
FUNCTION get_tsmorgan_is_number (p_org_id IN VARCHAR2) RETURN NUMBER IS

  v_is_nbr NUMBER(8);
  
  CURSOR c_tsmorgan_is_nbr (p_org_id IN VARCHAR2) IS 
    SELECT TSMORGAN_IS_NUMBER FROM TSMORGAN WHERE ORG_ID = RPAD(p_org_id,8);

BEGIN

   OPEN c_tsmorgan_is_nbr (p_org_id);
   FETCH c_tsmorgan_is_nbr INTO v_is_nbr;
   CLOSE c_tsmorgan_is_nbr;

   RETURN v_is_nbr;

END get_tsmorgan_is_number;

/******************************************************************************************************/
PROCEDURE CLEAR_STORET_EXPORT (p_export_log_seq IN NUMBER) IS

   v_export_log_seq     NUMBER(10);
   v_tsrfdact_is_number NUMBER(8);
   v_tsrfdact_org_id    VARCHAR2(8);
   v_tsrfqs_is_number   NUMBER(8);   
   v_tsrfqs_org_id      VARCHAR2(8);
   
   v_created_by         NUMBER(1);
   v_visit_is_nbr       NUMBER(8);
   v_visit_org_id       CHAR(8);
   v_trip_is_nbr        NUMBER(8);
   v_trip_org_id        CHAR(8);
   
   v_dummy_is_nbr       NUMBER(8);
   
   v_result_cnt         NUMBER(10) := 0;
   v_import_seq         NUMBER(10);
   

   CURSOR c_fa_export(p_export_log_seq NUMBER) IS
      SELECT FA_TSRFDACT_IS_NUMBER TSRFDACT_IS_NUMBER, FA_TSRFDACT_ORG_ID TSRFDACT_ORG_ID,
        FA_TSRFQS_IS_NUMBER TSRFQS_IS_NUMBER, FA_TSRFQS_ORG_ID TSRFQS_ORG_ID,
        FA_IMPORT_SEQ, FA_SSV_SEQ, FA_STP_SEQ
        FROM SIM_FIELD_ACTIVITIES WHERE fa_export_seq = p_export_log_seq;

   CURSOR c_get_visit_info(p_visit_seq IN NUMBER) IS
     SELECT SSV_CREATED_BY_SIM, SSV_TSRSTVST_IS_NUMBER, SSV_TSRSTVST_ORG_ID 
       FROM SIM_STATION_VISITS WHERE SSV_SEQ = p_visit_seq;
       
   CURSOR c_get_trip_info(p_trip_seq IN NUMBER) IS
     SELECT STP_CREATED_BY_SIM, STP_TSRTRIP_IS_NUMBER, STP_TSRTRIP_ORG_ID 
       FROM SIM_TRIPS WHERE STP_SEQ = p_trip_seq;
       
   CURSOR c_check_visit_in_STORET(p_visit_is_nbr IN NUMBER, p_visit_org_id IN VARCHAR2) IS
     SELECT TSRFDACT_IS_NUMBER FROM TSRFDACT WHERE TSRSTVST_IS_NUMBER = p_visit_is_nbr
       AND TSRSTVST_ORG_ID = RPAD(p_visit_org_id,8);

   CURSOR c_check_trip_in_STORET(p_trip_is_nbr IN NUMBER, p_trip_org_id IN VARCHAR2) IS
     SELECT TSRSTVST_IS_NUMBER FROM TSRSTVST WHERE TSRTRIP_IS_NUMBER = p_trip_is_nbr
       AND TSRTRIP_ORG_ID = RPAD(p_trip_org_id,8);

   CURSOR c_check_trip_qc(p_trip_is_nbr IN NUMBER, p_trip_org_id IN VARCHAR2) IS
     SELECT TSRFQS_IS_NUMBER FROM TSRFQS WHERE TSRTRIP_IS_NUMBER = p_trip_is_nbr
       AND TSRTRIP_ORG_ID = RPAD(p_trip_org_id,8);

   CURSOR c_result_is_nbr (p_org_id VARCHAR2, p_activity_is NUMBER) IS
      SELECT tsrrsult_is_number, tsrrsult_org_id FROM tsrrsult WHERE 
             tsrfdact_is_number = p_activity_is AND
             tsrfdact_org_id = RPAD(p_org_id,8);
          
   CURSOR c_qc_result_is_nbr (p_org_id VARCHAR2, p_trip_qc_is NUMBER) IS
      SELECT tsrrsult_is_number, tsrrsult_org_id FROM tsrrsult WHERE 
             tsrfqs_is_number = p_trip_qc_is AND
             tsrfqs_org_id = RPAD(p_org_id,8);

BEGIN
  
  FOR v_fa_export IN c_fa_export(p_export_log_seq) LOOP

    v_tsrfdact_is_number := v_fa_export.tsrfdact_is_number;
    v_tsrfdact_org_id := v_fa_export.tsrfdact_org_id;
       
    v_tsrfqs_is_number := v_fa_export.tsrfqs_is_number;   
    v_tsrfqs_org_id := v_fa_export.tsrfqs_org_id;

    IF v_tsrfdact_is_number IS NOT NULL THEN
      FOR v_result_is_nbr IN c_result_is_nbr (v_tsrfdact_org_id, v_tsrfdact_is_number) LOOP

        /* delete the tsrdql for each result*/
        DELETE TSRDQL WHERE 
        TSRRSULT_IS_NUMBER = v_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_result_is_nbr.tsrrsult_org_id,8);

         /* delete the tsmgntxt for each result */
        DELETE TSMGNTXT WHERE 
        TSRRSULT_IS_NUMBER = v_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_result_is_nbr.tsrrsult_org_id,8);
   
        /* kms - keep track of the number results deleted in order to update the import log later */
        IF v_result_cnt = 0 THEN
          v_import_seq := v_fa_export.fa_import_seq;
        END IF;
    
        v_result_cnt := v_result_cnt + 1;

      END LOOP;
      
      COMMIT;

         
      /* delete the results */
      DELETE TSRRSULT WHERE 
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);
      
      COMMIT;
      
     /* delete activity, person assignment */
      DELETE TSRFAPEA WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);
     
      /* delete the sample */
      DELETE TSRSMPLE WHERE 
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      /* delete the actual location record */
      DELETE TSRAAL WHERE 
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      /* delete the field set assmt */
      DELETE TSRFAFSA WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);
      
      /* delete activity, project assignment */
      DELETE TSRFAPRA WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);
         
      /* delete the activity */  
      DELETE TSRFDACT WHERE 
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);
      
      /* kms (6/11/01) - delete station visit and trip only if created by
         SIM and there are no other activities associated with them in
         either SIM or STORET. */
           
      OPEN c_get_visit_info(v_fa_export.FA_SSV_SEQ);
      FETCH c_get_visit_info INTO v_created_by,v_visit_is_nbr,v_visit_org_id;
      CLOSE c_get_visit_info;
        
      /* kms - if visit created by SIM, see if there are any other activities 
         associated with it and delete if not.  Otherwise, leave the visit. */
      IF v_created_by = 1 THEN
        
        /* kms - if visit is not used by any other activities in STORET, delete it from STORET */
        OPEN c_check_visit_in_STORET(v_visit_is_nbr,v_visit_org_id);
        FETCH c_check_visit_in_STORET INTO v_dummy_is_nbr;
          IF c_check_visit_in_STORET%NOTFOUND THEN
                
            /* delete field set for sta visit */
            DELETE TSRFDSET WHERE
            TSRSTVST_IS_NUMBER = v_visit_is_nbr AND TSRSTVST_ORG_ID = RPAD(v_visit_org_id,8);

            /* kms - delete the station visit */
            DELETE TSRSTVST WHERE TSRSTVST_IS_NUMBER = v_visit_is_nbr AND TSRSTVST_ORG_ID = v_visit_org_id;

            /* kms - update activities attached to this visit in SIM so they 
               are no longer directly associated with a station visit in STORET. */
            UPDATE SIM_FIELD_ACTIVITIES
              SET FA_TSRSTVST_IS_NUMBER = NULL,
                  FA_TSRSTVST_ORG_ID = NULL
              WHERE FA_SSV_SEQ = v_fa_export.FA_SSV_SEQ;
                
            UPDATE SIM_STATION_VISITS
              SET SSV_TSRSTVST_IS_NUMBER = NULL,
                  SSV_TSRSTVST_ORG_ID = NULL
              WHERE SSV_SEQ = v_fa_export.FA_SSV_SEQ;
                
            /* kms - since we know there are no more activities on this station visit, see if there
               are more station visits on the trip and delete if not.  We don't do this when the 
               visit was not created by SIM since we know there is at least station visit on it. */
            OPEN c_get_trip_info(v_fa_export.FA_STP_SEQ);
            FETCH c_get_trip_info INTO v_created_by,v_trip_is_nbr,v_trip_org_id;
            CLOSE c_get_trip_info;

            IF v_created_by = 1 THEN
                
              OPEN c_check_trip_in_STORET(v_trip_is_nbr,v_trip_org_id);
              FETCH c_check_trip_in_STORET INTO v_dummy_is_nbr;
                IF c_check_trip_in_STORET%NOTFOUND THEN
                  
                  /* kms - see if there are any trip qc samples on this trip */
                  OPEN c_check_trip_qc(v_trip_is_nbr,v_trip_org_id);
                  FETCH c_check_trip_qc INTO v_dummy_is_nbr;
                    IF c_check_trip_qc%NOTFOUND THEN

                      /* kms - no other station visits or trip qcs on this trip, delete trip and its associations */
                      DELETE TSRTSA WHERE TSRTRIP_IS_NUMBER = v_trip_is_nbr AND TSRTRIP_ORG_ID = v_trip_org_id;
                      DELETE TSRTPA WHERE TSRTRIP_IS_NUMBER  = v_trip_is_nbr AND TSRTRIP_ORG_ID = v_trip_org_id;
                      DELETE TSRTRIP WHERE TSRTRIP_IS_NUMBER = v_trip_is_nbr AND TSRTRIP_ORG_ID = v_trip_org_id;
                       
                      /* kms - update all activities in SIM so they are no longer associated with the trip in STORET. */
                      UPDATE SIM_FIELD_ACTIVITIES
                        SET FA_TSRTRIP_IS_NUMBER = NULL,
                            FA_TSRTRIP_ORG_ID = NULL
                        WHERE FA_STP_SEQ = v_fa_export.FA_STP_SEQ;
                          
                      /* kms - update trip in SIM so it's no longer associated with anything in STORET. */
                      UPDATE SIM_TRIPS
                        SET STP_TSRTRIP_IS_NUMBER = NULL,
                            STP_TSRTRIP_ORG_ID = NULL
                        WHERE STP_SEQ = v_fa_export.FA_STP_SEQ;
                      
                    END IF;
                  CLOSE c_check_trip_qc;                    
                    
                END IF;
              CLOSE c_check_trip_in_STORET;
            END IF;
              
          END IF;
        CLOSE c_check_visit_in_STORET;
        
      END IF;
      
      COMMIT;
      
    ELSE
      /* different set of deletes for trip qc data */
      FOR v_result_is_nbr IN c_qc_result_is_nbr (v_tsrfqs_org_id, v_tsrfqs_is_number) LOOP

        /* delete the tsrdql for each result*/
        DELETE TSRDQL WHERE 
        TSRRSULT_IS_NUMBER = v_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_result_is_nbr.tsrrsult_org_id,8);

        /* kms - keep track of the number results deleted in order to update the import log later */
        IF v_result_cnt = 0 THEN
          v_import_seq := v_fa_export.fa_import_seq;
        END IF;
    
        v_result_cnt := v_result_cnt + 1;
   
      END LOOP;
      
      COMMIT;
         
      /* delete the results */
      DELETE TSRRSULT WHERE 
      TSRFQS_IS_NUMBER = v_tsrfqs_is_number AND
      TSRFQS_ORG_ID = RPAD(v_tsrfqs_org_id,8);
      
      COMMIT;
      
      /* delete trip qc, person assignment */
      DELETE TSRFQSPA WHERE 
      TSRFQS_IS_NUMBER = v_tsrfqs_is_number AND
      TSRFQS_ORG_ID = RPAD(v_tsrfqs_org_id,8);
         
      /* delete the activity */  
      DELETE TSRFQS WHERE 
      TSRFQS_IS_NUMBER = v_tsrfqs_is_number AND
      TSRFQS_ORG_ID = RPAD(v_tsrfqs_org_id,8);
    
      COMMIT;
      
    END IF;
    
    /* grab the import seq from the first activity, 
       and increment counter SNG 4/26/01 */
    /* kms (6/11/01) - changed so this counts results instead of activities since the counts
       associated with an activity import actually are counts of results. */
--    IF v_activity_cnt = 0 THEN
--       v_import_seq := v_fa_export.fa_import_seq;
--    END IF;
    
--    v_activity_cnt := v_activity_cnt + 1;
    
  END LOOP;

  COMMIT;
   
  UPDATE SIM_FIELD_ACTIVITIES
  SET FA_EXPORT_SEQ = NULL, FA_STATUS = 'A'
    WHERE FA_EXPORT_SEQ = p_export_log_seq;
  
  /* 
  UPDATE SIM_EXPORT_LOG
    SET SEL_CLEARED_BY = USER, SEL_CLEARED_ON = SYSDATE WHERE SEL_SEQ = p_export_log_seq;
  */
  DELETE SIM_EXPORT_DETAILS WHERE SED_SEL_SEQ = p_export_log_seq;
  DELETE SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;
  
   /* update the import log with appropriate info sng 4/26/01*/
  UPDATE SIM_IMPORT_LOG
  SET 
  SIL_ROWS_READY = SIL_ROWS_READY + v_result_cnt,
  SIL_EXPORTED_ON = NULL
  WHERE SIL_SEQ = v_import_seq;


  COMMIT;

END CLEAR_STORET_EXPORT;

/******************************************************************************************************/
PROCEDURE WRITE_ERROR (p_export_seq IN NUMBER, p_desc IN VARCHAR2) IS

BEGIN

 INSERT INTO SIM_EXPORT_DETAILS (SED_SEQ , SED_SEL_SEQ, SED_DESC ) VALUES (
    SIM_EXPORT_DETAILS_SEQ.NEXTVAL, p_export_seq, p_desc);

 COMMIT;

END WRITE_ERROR;

/******************************************************************************************************/
FUNCTION GET_EXPORT_LOG_SEQ RETURN NUMBER IS

   CURSOR c_export_log_seq IS select SIM_EXPORT_LOG_SEQ.NEXTVAL FROM DUAL;
   
   v_export_log_seq NUMBER(10);
   
BEGIN

   OPEN c_export_log_seq;
   FETCH c_export_log_seq INTO v_export_log_seq;
   CLOSE c_export_log_seq;
   
   RETURN v_export_log_seq;

END GET_EXPORT_LOG_SEQ;

/******************************************************************************************************/
PROCEDURE clear_station_export (p_export_log_seq IN NUMBER) IS

   CURSOR c_export_org (p_export_log_seq IN NUMBER) IS
     SELECT sel_org_id FROM sim_export_log WHERE sel_seq = p_export_log_seq;

   CURSOR c_stations (p_export_log_seq IN NUMBER) IS
     SELECT sta_is_number, sta_tsmorgan_org_id, sta_import_seq
     FROM sim_stations WHERE sta_export_seq = p_export_log_seq;
     
   CURSOR c_statn_visit (p_export_log_seq IN NUMBER) IS      
     SELECT s.sta_name FROM sim_stations s, tsrstvst v
     WHERE s.sta_is_number = v.tsmstatn_is_number
     AND   rpad(s.sta_tsmorgan_org_id,8) = v.tsmstatn_org_id
     AND   s.sta_export_seq = p_export_log_seq;
       
   CURSOR c_interval (p_well_is_nbr IN NUMBER) IS
     SELECT tsmintvl_is_number, tsmintvl_org_id FROM tsmintvl
     WHERE tsmwell_is_number = p_well_is_nbr;

   CURSOR c_well (p_station_is_nbr IN NUMBER) IS
     SELECT tsmwell_is_number, tsmwell_org_id FROM tsmwell
     WHERE tsmstatn_is_number = p_station_is_nbr;

   v_org_id      VARCHAR2(8);    
   v_station_cnt NUMBER(10)  := 0;
   v_import_seq  NUMBER(10);
   v_station     VARCHAR2(60);
   e_VisitsFound EXCEPTION;
         
BEGIN

  /* bka - Check to make sure that no stations from this migration already have visits assigned to them in STORET */
  OPEN c_statn_visit(p_export_log_seq);
    FETCH c_statn_visit INTO v_station;
    IF c_statn_visit%FOUND THEN 
      WRITE_ERROR(p_export_log_seq,
        'Error: Station '||v_station||' already has station visits assigned to it.  This migration cannot be removed from STORET');
      RAISE e_VisitsFound;
    END IF;
  CLOSE c_statn_visit;

  /* Get the org id, so can pass to seq update process */
  OPEN c_export_org(p_export_log_seq);
    FETCH c_export_org INTO v_org_id;
  CLOSE c_export_org;

  FOR v_stations IN c_stations(p_export_log_seq) LOOP
  
    FOR v_well IN c_well(v_stations.sta_is_number) LOOP
    
      FOR v_interval IN c_interval(v_well.tsmwell_is_number) LOOP                                              
        DELETE TSMINTVL WHERE TSMINTVL_IS_NUMBER = v_interval.TSMINTVL_IS_NUMBER 
                          AND TSMINTVL_ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);
        DELETE TSMCSNG  WHERE TSMINTVL_IS_NUMBER = V_INTERVAL.TSMINTVL_IS_NUMBER 
                          AND TSMINTVL_ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);
        DELETE TSMIGUA  WHERE TSMINTVL_IS_NUMBER = V_INTERVAL.TSMINTVL_IS_NUMBER 
                          AND TSMIGUA_ORG_ID     = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);
      END LOOP;
      
      DELETE TSMWELL WHERE TSMWELL_IS_NUMBER = v_well.TSMWELL_IS_NUMBER 
                       AND TSMWELL_ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);
    END LOOP;  
        
    DELETE TSMALP   WHERE TSMSTATN0ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8) 
                      AND TSMSTATN0IS_NUMBER = V_STATIONS.STA_IS_NUMBER;
    DELETE TSMSTATN WHERE TSMSTATN_IS_NUMBER = V_STATIONS.STA_IS_NUMBER 
                      AND TSMSTATN_ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);
    DELETE TSMPSA   WHERE TSMSTATN_IS_NUMBER = V_STATIONS.STA_IS_NUMBER 
                      AND TSMSTATN_ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);

    /* get the import seq from the first record, use for changing the count 
       of records that have been exported in the import log SNG 4/26/01*/  
    IF v_station_cnt = 0 THEN
       v_import_seq := v_stations.sta_import_seq;
    END IF;  
 
    v_station_cnt := v_station_cnt + 1;

    COMMIT;

  END LOOP;
  
  UPDATE SIM_STATIONS
    SET STA_EXPORT_SEQ = NULL, STA_STATUS = 'A', STA_IS_NUMBER = NULL
    WHERE STA_EXPORT_SEQ = p_export_log_seq;
     
  DELETE SIM_EXPORT_DETAILS WHERE SED_SEL_SEQ = p_export_log_seq;
  DELETE SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;
  
  /* update the import log with appropriate info sng 4/26/01 */
  UPDATE  SIM_IMPORT_LOG
    SET   SIL_ROWS_READY  = SIL_ROWS_READY + v_station_cnt,
          SIL_EXPORTED_ON = NULL
    WHERE SIL_SEQ = v_import_seq;
  
  COMMIT;   
  
EXCEPTION
  WHEN e_VisitsFound THEN
    RAISE;   
      
END CLEAR_STATION_EXPORT;

/******************************************************************************************************/
PROCEDURE clear_project_export (p_export_log_seq IN NUMBER) IS

   v_tsmproj_is_number NUMBER(8);
   v_tsmproj_org_id    VARCHAR2(8);
   v_project_cnt       NUMBER(10) := 0;
   v_import_seq        NUMBER(10);
   
   CURSOR c_project_export(p_export_log_seq NUMBER) IS
      SELECT SPJ_TSMPROJ_IS_NUMBER TSMPROJ_IS_NUMBER,
       SPJ_TSMPROJ_ORG_ID TSMPROJ_ORG_ID,
       spj_import_seq
      FROM SIM_PROJECTS WHERE SPJ_EXPORT_SEQ = p_export_log_seq;

          
BEGIN
  
  FOR v_project_export IN c_project_export(p_export_log_seq) LOOP

    v_tsmproj_org_id := v_project_export.tsmproj_org_id;
         
    /* delete the tsmgntxt for each project record */
    DELETE TSMGNTXT WHERE 
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);
    
    /* delete project, station association */         
    DELETE TSMPSA WHERE
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);
      
    /* delete project, person association */
    DELETE TSMPPA WHERE
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);
    
    /* delete project, person, role association */
    DELETE TSMPPRA WHERE
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);
    
    /* delete the project */  
    DELETE TSMPROJ WHERE 
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);

    COMMIT;
      
    /* get the import seq from the first record, use for changing the count 
       of records that have been exported in the import log sng 4/26/01*/  
    IF v_project_cnt = 0 THEN
      v_import_seq := v_project_export.spj_import_seq;
    END IF;  
      
    v_project_cnt := v_project_cnt + 1;
      
  END LOOP;

  /*  DELETE THE export log records */
--  SNG 4/26/01 DELETE sim_visit_export_log where export_log_seq = p_export_log_seq;
--  sng 4/26/01 COMMIT;
   
  UPDATE SIM_PROJECTS
    SET SPJ_EXPORT_SEQ = NULL, SPJ_STATUS = 'A'
    WHERE SPJ_EXPORT_SEQ = p_export_log_seq;
  
 
  DELETE SIM_EXPORT_DETAILS WHERE SED_SEL_SEQ = p_export_log_seq;
  DELETE SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;
  
  /* update the import log with appropriate info sng 4/26/01 */
  UPDATE SIM_IMPORT_LOG
  SET 
  SIL_ROWS_READY = SIL_ROWS_READY + v_project_cnt,
  SIL_EXPORTED_ON = NULL
  WHERE SIL_SEQ = v_import_seq;
   
      
  COMMIT;

END clear_project_export;

/******************************************************************************************************/
FUNCTION CLEAR_EXPORT (p_export_log_seq IN NUMBER) RETURN NUMBER IS

   CURSOR c_export (p_export_log_seq IN NUMBER) IS
       SELECT SEL_EXPORT_TYPE FROM SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;

   v_export_type VARCHAR2(1);    
       
BEGIN

   OPEN c_export (p_export_log_seq);
   FETCH c_export INTO v_export_type;
   CLOSE c_export;
   

   IF v_export_type = 'S' OR v_export_type = 'G' THEN
     CLEAR_STATION_EXPORT(p_export_log_seq);
   ELSIF v_export_type = 'P' THEN
     CLEAR_PROJECT_EXPORT(p_export_log_seq);
   ELSIF (v_export_type = 'R') OR (v_export_type IS NULL) THEN
     CLEAR_STORET_EXPORT(P_EXPORT_LOG_SEQ);
   END IF;
      
   RETURN 1;
   
EXCEPTION
  WHEN OTHERS THEN
    WRITE_ERROR(p_export_log_seq,SQLERRM);
    RETURN 0;
   
END CLEAR_EXPORT;

/******************************************************************************************************/

END SIM2_EXPORT_PKG;
/
